﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CSConsoleApp
{



    public class ShopCartitem
    {
        public int quantity
        {
            get;
            set;
        }

        public string itemname
        {
            get;
            set;
        }

        public double itemprice
        {
            get;
            set;
        }

        public double tax
        {
            get;
            set;
        }
    }

    class Program
    {
        static void Main(string[] args)
        {


            

            //Console.WriteLine(iLim.ToString());
            //Console.WriteLine(jLim.ToString());
            CalculateTax3();
            Console.Read();

        }


        private static double CalculateTax1()
        {
            double result = 0;

            //Input 1:
            //1 book at 12.49
            //1 music CD at 14.99
            //1 chocolate bar at 0.85

            List<ShopCartitem> items = new List<ShopCartitem>();

            items.Add(new ShopCartitem() //book:Tax Excemtion
            {
                quantity = 1,
                itemname = "book",
                itemprice = 12.49,
                tax  =0.00
            });

            items.Add(new ShopCartitem() 
            { 
                quantity = 1,
                itemname = "music CD",
                itemprice = 14.99,
                tax = (14.99/100) * 10 //10% tax
            });

            items.Add(new ShopCartitem()  //food:Tax Excemtion
            {
                quantity = 1,
                itemname = "chocolate bar",
                itemprice = 0.85,
                tax = 0.00
            });

            
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|~~~~~~~~~~~ SHOPPER'S WORLD~~~~~~~~~~|");
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|---------------RECEIPT---------------|");
            Console.WriteLine("|                                     |");
            Console.WriteLine("|Date: " + DateTime.Now.ToString("dd/mm/yyyy HH-MM-ss") + "------------|");
            Console.WriteLine("|                                     |");
            Console.WriteLine("|                                     |");
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|---------------PARTICULARS-----------|");
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|                                     |");
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|QTY| ITEM NAME              | PRICE  |");
            Console.WriteLine("|-------------------------------------|");
            


            double itemTotal = 0.00;
            double taxTotal  = 0.00;
            double total = 0.00;

            itemTotal = items.Sum(c => c.itemprice );

            taxTotal = items.Sum(c => c.tax);

            total = itemTotal + taxTotal;

            string sFormat = "|{0}| {1}| {2}  |";

            foreach (ShopCartitem cart in items)
            {
                Console.WriteLine("|-------------------------------------|");
                Console.WriteLine(String.Format(sFormat,cart.quantity,cart.itemname, String.Format("{0:0.00}",Math.Round(Math.Round(cart.itemprice,2) + Math.Round(cart.tax,2),2))));
                Console.WriteLine("|-------------------------------------|");
            }
            Console.WriteLine(String.Format(sFormat, 3, "Sub Total", String.Format("{0:0.00}",Math.Round(itemTotal,2))));
            Console.WriteLine(String.Format(sFormat, 3, "Sales Tax", String.Format("{0:0.00}",Math.Round(taxTotal,2))));
            Console.WriteLine(String.Format(sFormat, 3, "Amount to be paid", String.Format("{0:0.00}", Math.Round(total, 2))));

            //tax 10%;


            return result;
        }



        private static double CalculateTax2()
        {
            double result = 0;

//Input 2:
//1 imported box of chocolates at 10.00
//1 imported bottle of perfume at 47.50

            List<ShopCartitem> items = new List<ShopCartitem>();

            items.Add(new ShopCartitem() //food: local tax excemption - but import tax 5% valid
            {
                quantity = 1,
                itemname = "imported box of chocolates",
                itemprice = 10.00,
                tax = (10.00 / 100.00) * 5 
            });

            items.Add(new ShopCartitem() // local tax 10% + import tax 5% => 15% tax
            {
                quantity = 1,
                itemname = "imported bottle of perfume",
                itemprice = 47.50,
                tax = (47.50 / 100.00) * 15.00
            });

           

            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|~~~~~~~~~~~ SHOPPER'S WORLD~~~~~~~~~~|");
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|---------------RECEIPT---------------|");
            Console.WriteLine("|                                     |");
            Console.WriteLine("|Date: " + DateTime.Now.ToString("dd/mm/yyyy HH-MM-ss") + "------------|");
            Console.WriteLine("|                                     |");
            Console.WriteLine("|                                     |");
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|---------------PARTICULARS-----------|");
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|                                     |");
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|QTY| ITEM NAME              | PRICE  |");
            Console.WriteLine("|-------------------------------------|");



            double itemTotal = 0.00;
            double taxTotal = 0.00;
            double total = 0.00;

            itemTotal = items.Sum(c => c.itemprice);

            taxTotal = items.Sum(c => c.tax);

            total = itemTotal + taxTotal;

            string sFormat = "|{0}| {1}| {2}  |";

            foreach (ShopCartitem cart in items)
            {
                double itemPrice = Math.Round(cart.itemprice + cart.tax,2);
                Console.WriteLine("|-------------------------------------|");
                Console.WriteLine(String.Format(sFormat, cart.quantity, cart.itemname, String.Format("{0:0.00}", Math.Round(itemPrice, 2))));
                Console.WriteLine("|-------------------------------------|");
            }
            Console.WriteLine(String.Format(sFormat, 3, "Sub Total", String.Format("{0:0.00}", Math.Round(itemTotal, 2))));
            Console.WriteLine(String.Format(sFormat, 3, "Sales Tax", String.Format("{0:0.00}", Math.Round(taxTotal, 2))));
            Console.WriteLine(String.Format(sFormat, 3, "Amount to be paid", String.Format("{0:0.00}", Math.Round(total, 2))));

            //tax 10%;


            return result;
        }

        private static double CalculateTax3()
        {
            double result = 0;

        //Input 3:
        //1 imported bottle of perfume at 27.99
        //1 bottle of perfume at 18.99
        //1 packet of headache pills at 9.75
        //1 box of imported chocolates at 11.25

            List<ShopCartitem> items = new List<ShopCartitem>();

            items.Add(new ShopCartitem() // local tax 10% + import tax 5% => 15% tax
            {
                quantity = 1,
                itemname = "imported bottle of perfume",
                itemprice = 27.99,
                tax = Math.Round(27.99 / 100.00,2) * 15.00 
            });

            items.Add(new ShopCartitem() // local tax 10% 
            {
                quantity = 1,
                itemname = "bottle of perfume at",
                itemprice = 18.99,
                tax = Math.Round(18.99 / 100.00,2) * 10.00
            });

            items.Add(new ShopCartitem() // medicine tax excemption 
            {
                quantity = 1,
                itemname = "packet of headache pills",
                itemprice = 9.75,
                tax = 0.00
            });

            items.Add(new ShopCartitem() // food: local tax excemtion, but import tax 5%
            {
                quantity = 1,
                itemname = "box of imported chocolates",
                itemprice = 11.25,
                tax = Math.Round(11.25 / 100.00,2) * 5.00
            });

 

            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|~~~~~~~~~~~ SHOPPER'S WORLD~~~~~~~~~~|");
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|---------------RECEIPT---------------|");
            Console.WriteLine("|                                     |");
            Console.WriteLine("|Date: " + DateTime.Now.ToString("dd/mm/yyyy HH-MM-ss") + "------------|");
            Console.WriteLine("|                                     |");
            Console.WriteLine("|                                     |");
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|---------------PARTICULARS-----------|");
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|                                     |");
            Console.WriteLine("|-------------------------------------|");
            Console.WriteLine("|QTY| ITEM NAME              | PRICE  |");
            Console.WriteLine("|-------------------------------------|");



            double itemTotal = 0.00;
            double taxTotal = 0.00;
            double total = 0.00;

            itemTotal = items.Sum(c => c.itemprice);

            taxTotal = items.Sum(c => c.tax);

            total = itemTotal + taxTotal;

            string sFormat = "|{0}| {1}| {2}  |";

            foreach (ShopCartitem cart in items)
            {
                double itemPrice = Math.Round(cart.itemprice + cart.tax,2);
                Console.WriteLine("|-------------------------------------|");
                Console.WriteLine(String.Format(sFormat, cart.quantity, cart.itemname, String.Format("{0:0.00}", Math.Round(itemPrice, 2))));
                Console.WriteLine("|-------------------------------------|");
            }
            Console.WriteLine(String.Format(sFormat, 3, "Sub Total", String.Format("{0:0.00}", Math.Round(itemTotal, 2))));
            Console.WriteLine(String.Format(sFormat, 3, "Sales Tax", String.Format("{0:0.00}", Math.Round(taxTotal, 2))));
            Console.WriteLine(String.Format(sFormat, 3, "Amount to be paid", String.Format("{0:0.00}", Math.Round(total, 2))));

            //tax 10%;


            return result;
        }




        private void SwapArray()
        {
            //Code to Swap a 2 x 3 array to 3 x 2

            //2 by 3 array
            int[,] i2by3 = new[,] { { 1, 2, 3 }, { 4, 5, 6 } };

            //3 by 2 array
            int[,] i3by2  = new int[3,2];

            for (int i = 0; i < 2; i++)
            {
                for (int j = 0; j < 3; j++)
                {
                    i3by2[j, i] = i2by3[i, j];
                }
            }
        }

    }
}
